import React, { useState } from 'react';
import ContactFormPopup from '../ContactFormPopup';

export default function ContactButton() {
  const [isOpen, setIsOpen] = useState(false);

  return (
    <>
      <button
        onClick={() => setIsOpen(true)}
        className="bg-amber-600 text-white px-6 py-2 rounded-md hover:bg-amber-700 transition-colors font-medium"
      >
        Contact Us
      </button>
      <ContactFormPopup isOpen={isOpen} onClose={() => setIsOpen(false)} />
    </>
  );
}